'use strict';

const axios = require('axios');
const { alipaySdk } = require("../utils/common");

exports.main = async function (event, context) {
  const queryForm = event.body;
  console.log("queryForm:", queryForm);

  const queryArray = queryForm.split("&");

  let entries = new Map();
  for (let i = 0; i < queryArray.length; i++) {
    let pair = queryArray[i].split("=");
    let key = pair[0];
    let value = pair[1];
    if (key !== "sign_type") {
      if (key.includes("gmt") || key.includes("time")) {
        entries.set(key, decodeURIComponent(value).replaceAll("+", " "));
      } else {
        entries.set(key, decodeURIComponent(value));
      }
    }
  }

  const notification = Object.fromEntries(entries);
  console.log("notification:", notification);

  const checkSignSuccess = alipaySdk.checkNotifySign(notification);
  if (!checkSignSuccess) {
    console.log("check sign failed")
    return {
      statusCode: 400,
    };
  }

  const {app_id, out_trade_no, trade_status, total_amount} = notification;

  console.log('App id', JSON.stringify(app_id));
  console.log('Trade status', JSON.stringify(trade_status));
  if (app_id !== alipaySdk.config.appId) {
    return {
      statusCode: 400,
    };
  }

  let paymentSuccess = false
  if (trade_status === "TRADE_SUCCESS" || trade_status === "TRADE_FINISHED") {
    paymentSuccess = true
  }

  const {UOS_APP_ID, UOS_APP_SERVICE_SECRET} = process.env;

  try {
    const response = await axios.post('https://p.unity.cn/v1/payments/notify', {
      outTradeNo: out_trade_no,
      tradeState: trade_status,
      totalAmount: total_amount*100,
      paymentSuccess: paymentSuccess
    }, {
      headers: {
        'Content-Type': 'application/json',
        'Authorization': 'Basic ' + btoa(UOS_APP_ID + ':' + UOS_APP_SERVICE_SECRET)
      }
    });

  } catch (err) {
    console.error(err);
    return {
      statusCode: 400,
      headers: {"Content-Type":"application/json"},
      body: JSON.stringify(err.response.data),
    };
  }

  return {
    statusCode: 200,
    headers: {"Content-Type":"text/html"},
    body: "success",
  };
};

